/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.locales;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.skinsrestorer.shadow.aikar.locales.MessageKeyProvider;

public class MessageKey
implements MessageKeyProvider {
    private static final AtomicInteger counter = new AtomicInteger(1);
    private static final Map<String, MessageKey> keyMap = new ConcurrentHashMap<String, MessageKey>();
    private final int id = counter.getAndIncrement();
    private final String key;

    private MessageKey(String key) {
        this.key = key;
    }

    public static MessageKey of(String key) {
        return keyMap.computeIfAbsent(key.toLowerCase().intern(), MessageKey::new);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public MessageKey getMessageKey() {
        return this;
    }
}

